unit EZTWAIN;


interface

Uses Windows;
 CONST TWAIN_BW	= $0001;	// 1-bit per pixel, B&W 	(== TWPT_BW)
 TWAIN_GRAY	= $0002;	// 1,4, or 8-bit grayscale  (== TWPT_GRAY)
 TWAIN_RGB	= $0004;	// 24-bit RGB color         (== TWPT_RGB)
 TWAIN_PALETTE	= $0008;	// 1,4, or 8-bit palette    (== TWPT_PALETTE)
 TWAIN_ANYTYPE	= $0000;	// any of the above



  Function  TWAIN_AcquireNative(hwndApp: HWND; wPixTypes: INTEGER): THandle; stdcall;
  Procedure  TWAIN_FreeNative(hdib : THandle);stdcall;
  Function  TWAIN_AcquireToClipboard(hwndApp:HWND; wPixTypes:INTEGER):BOOLEAN;stdcall;
  Function  TWAIN_AcquireToFilename (hwndApp:THandle; pszFile:PCHAR):INTEGER;stdcall;
  Function  TWAIN_SelectImageSource(hwnd : THandle):BOOLEAN; stdcall;
  Function  TWAIN_IsAvailable :BOOLEAN;stdcall;
  Function  TWAIN_EasyVersion :INTEGER;stdcall;
  Function  TWAIN_State       : INTEGER; stdcall;
  Function  TWAIN_DibDepth(hdib : THandle):INTEGER;stdcall;
  Function  TWAIN_DibWidth(hdib : THandle):INTEGER;stdcall;
  Function  TWAIN_DibHeight(hdib : THandle):INTEGER;stdcall;
  Function  TWAIN_DibNumColors(hdib : THandle):INTEGER;stdcall;
  Function  TWAIN_CreateDibPalette(hdib : THandle):HPalette; stdcall;
  Procedure TWAIN_DrawDibToDC(dc  : HDC;	       // destination device context
		dx, dy : INTEGER;	               // destination (x,y)
		w,   h : INTEGER;	               // width and height
		hdib   : THandle;	               // DIB handle
		sx,sy  : INTEGER 	               // source (x,y) in DIB
		); stdcall;

  Function  TWAIN_WriteNativeToFilename(hdib:THandle; pszFile : PCHAR):INTEGER; stdcall;
  Function  TWAIN_WriteNativeToFile(hdib:THandle; fh:HFile):INTEGER; stdcall;
  Function  TWAIN_LoadNativeFromFilename(pszFile:PCHAR):THandle;stdcall;
  Function  TWAIN_LoadNativeFromFile(fh:HFILE):THandle;stdcall;
  Procedure TWAIN_RegisterApp( 	nMajorNum, nMinorNum: INTEGER;
                                nLanguage : INTEGER;
                                nCountry  : INTEGER;
                                lpszVersion : PCHAR;
	                       	lpszMfg     : PCHAR;
                               	lpszFamily  : PCHAR;
	                       	lpszProduct : PCHAR);stdcall;

  Procedure TWAIN_SetHideUI(fhide : INTEGER); stdcall;
  Function TWAIN_GetHideUI:INTEGER; stdcall;
  Function TWAIN_GetResultCode:INTEGER;stdcall;

  Function TWAIN_GetConditionCode:INTEGER;stdcall;

  Function TWAIN_LoadSourceManager : BOOLEAN; stdCall;
  Function TWAIN_OpenSourceManager(handle : THandle):BOOLEAN; stdcall;
  Function TWAIN_OpenDefaultSource:BOOLEAN;stdcall;
  Function TWAIN_EnableSource (handle: HWND):BOOLEAN;stdcall;
  Function TWAIN_DisableSource:BOOLEAN; stdcall;
  Function TWAIN_CloseSource:BOOLEAN; stdcall;
  Function TWAIN_CloseSourceManager(handle : HWND):BOOLEAN; stdcall;
  Function TWAIN_UnloadSourceManager:BOOLEAN;stdcall;
  Function TWAIN_MessageHook(lpmssg:PMSG):BOOLEAN; stdcall;
  PROCEDURE TWAIN_ModalEventLoop; stdcall;

  Function TWAIN_AbortAllPendingXfers :BOOLEAN; stdcall;
  Function  TWAIN_WriteDibToFile(lpDIB: PBitmapInfoHeader; fh: HFILE):BOOLEAN; stdcall;
  Function TWAIN_NegotiateXferCount(nXFers : INTEGER):INTEGER;stdcall;
  Function TWAIN_NegotiatePixelTypes(wPixType : INTEGER):BOOLEAN; stdcall;
  Function TWAIN_GetCurrentUnits:INTEGER; stdcall;
  Function TWAIN_SetCurrentUnits (nUnits : INTEGER):Integer; stdcall;
  Function TWAIN_GetBitDepth :INTEGER; stdcall;
  Function TWAIN_SetBitDepth(nBits : INTEGER):BOOLEAN;stdcall;
  Function TWAIN_GetPixelType:INTEGER; stdcall;
  Function TWAIN_SetCurrentPixelType (nPixType : INTEGER):INTEGER; stdcall;
  Function TWAIN_GetCurrentResolution :DOUBLE;stdcall;
  Function TWAIN_SetCurrentResolution (dRes : DOUBLE):INTEGER;stdcall;
  Function TWAIN_SetCapOneValue(Cap : INTEGER; ItemType:INTEGER; itemVal:INTEGER):BOOLEAN;  stdcall;
  Function TWAIN_GetCapCurrent (Cap : INTEGER; ItemType : INTEGER; pVal:POINTER):BOOLEAN; stdcall;
  Function TWAIN_DS (DG : INTEGER; DAT : INTEGER; MSG : INTEGER; pData:POINTER):BOOLEAN; stdcall;
  Function TWAIN_Mgr(DG : INTEGER; DAT : INTEGER; MSG : INTEGER; pData:POINTER):BOOLEAN; stdcall;


implementation


//--------- Basic calls

Function  TWAIN_AcquireNative;external 'eztw32.dll' name 'TWAIN_AcquireNative';
// HANDLE EZTAPI TWAIN_AcquireNative(HWND hwndApp, unsigned wPixTypes);
// The minimal use of eztw32.dll is to just call this routine, with 0 for
// both params.  EZTWAIN creates a window if hwndApp is 0.
//
// Acquires a single image, from the currently selected Data Source, using
// Native-mode transfer. It waits until the source closes (if it's modal) or
// forces the source closed if not.  The return value is a handle to the
// acquired image.  Only one image can be acquired per call.
//
// Under Windows, the return value is a global memory handle - applying
// GlobalLock to it will return a (huge) pointer to the DIB, which
// starts with a BITMAPINFOHEADER.
// NOTE: You are responsible for disposing of the returned DIB - these things
// can eat up your Windows memory fast!  See TWAIN_FreeNative below.
//
// The image type can be restricted using the following masks.  A mask of 0
// means 'any pixel type is welcome'.
// Caution: You should not assume that the source will honor a pixel type
// restriction!  If you care, check the parameters of the DIB.


Procedure   TWAIN_FreeNative; external 'eztw32.dll' name 'TWAIN_FreeNative';
// void EZTAPI TWAIN_FreeNative(HANDLE hdib);
// Release the memory allocated to a native format image, as returned by
// TWAIN_AcquireNative. (If you are coding in C or C++, this is just a call
// to GlobalFree.)
// If you use TWAIN_AcquireNative and don't free the returned image handle,
// it stays around taking up Windows (virtual) memory until your application
// terminates.  Memory required per square inch:
//             1 bit B&W       8-bit grayscale     24-bit color
// 100 dpi      1.25KB              10KB               30KB
// 200 dpi        5KB               40KB              120KB
// 300 dpi      11.25KB             90KB              270KB
// 400 dpi       20KB              160KB              480KB
//


Function  TWAIN_AcquireToClipboard; external 'eztw32.dll' name 'TWAIN_AcquireToClipboard';
// int EZTAPI TWAIN_AcquireToClipboard(HWND hwndApp, unsigned wPixTypes);
// Like AcquireNative, but puts the resulting image, if any, into the system
// clipboard.  Under Windows, this will put a CF_DIB item in the clipboard
// if successful.  If this call fails, the clipboard is either empty or
// contains the old contents.
// A return value of 1 indicates success, 0 indicates failure.
//
// Useful for environments like Visual Basic where it is hard to make direct
// use of a DIB handle.  In fact, TWAIN_AcquireToClipboard uses
// TWAIN_AcquireNative for all the hard work.


Function   TWAIN_AcquireToFilename; external 'eztw32.dll' name 'TWAIN_AcquireToFilename';
// int EZTAPI TWAIN_AcquireToFilename(HWND hwndApp, char *pszFile);
// Acquire an image and write it to a .BMP (Windows Bitmap) file.
// The file name and path in pszFile are used.  If pszFile is NULL or
// points to an empty string, the user is prompted with a Save File dialog.
// Return values:
// -1 means the Acquire failed.
//  0 means the Save failed (or was cancelled)
//  1 indicates success.

Function TWAIN_SelectImageSource; external 'eztw32.dll' name 'TWAIN_SelectImageSource';
// int EZTAPI TWAIN_SelectImageSource(HWND hwnd);
// This is the routine to call when the user chooses the "Select Source..."
// menu command from your application's File menu.  Your app has one of
// these, right?  The TWAIN spec calls for this feature to be available in
// your user interface, preferably as described.
// Note: If only one TWAIN device is installed on a system, it is selected
// automatically, so there is no need for the user to do Select Source.
// You should not require your users to do Select Source before Acquire.
//
// This function posts the Source Manager's Select Source dialog box.
// It returns after the user either OK's or CANCEL's that dialog.
// A return of 1 indicates OK, 0 indicates one of the following:
//   a) The user cancelled the dialog
//   b) The Source Manager found no data sources installed
//   c) There was a failure before the Select Source dialog could be posted
// -- details --
// Only sources that can return images (that are in the DG_IMAGE group) are
// displayed.  The current default source will be highlighted initially.
// In the standard implementation of "Select Source...", your application
// doesn't need to do anything except make this one call.
//
// If you want to be meticulous, disable your "Acquire" and "Select Source"
// menu items or buttons if TWAIN_IsAvailable() returns 0 - see below.


//--------- Basic TWAIN Inquiries

Function TWAIN_IsAvailable; external 'eztw32.dll' name 'TWAIN_IsAvailable';
// int EZTAPI TWAIN_IsAvailable(void);
// Call this function any time to find out if TWAIN is installed on the
// system.  It takes a little time on the first call, after that it's fast,
// just testing a flag.  It returns 1 if the TWAIN Source Manager is
// installed & can be loaded, 0 otherwise.


Function TWAIN_EasyVersion; external 'eztw32.dll' name 'TWAIN_EasyVersion';
// int EZTAPI TWAIN_EasyVersion(void);
// Returns the version number of eztw32.dll, multiplied by 100.
// So e.g. version 2.01 will return 201 from this call.


Function  TWAIN_State; external 'eztw32.dll' name 'TWAIN_State';
 // int EZTAPI TWAIN_State(void);
 // Returns the TWAIN Protocol State per the spec.
CONST TWAIN_PRESESSION	        = 1;	// source manager not loaded
    TWAIN_SM_LOADED		= 2;	// source manager loaded
    TWAIN_SM_OPEN		= 3;	// source manager open
    TWAIN_SOURCE_OPEN		= 4;	// source open but not enabled
    TWAIN_SOURCE_ENABLED	= 5;	// source enabled to acquire
    TWAIN_TRANSFER_READY	= 6;	// image ready to transfer
    TWAIN_TRANSFERRING		= 7;	// image in transit

//--------- DIB handling utilities ---------

Function TWAIN_DibDepth;external 'eztw32.dll' name 'TWAIN_DibDepth';
//int EZTAPI TWAIN_DibDepth(HANDLE hdib);
// Depth of DIB, in bits i.e. bits per pixel.

Function TWAIN_DibWidth;external 'eztw32.dll' name 'TWAIN_DibWidth';
//int EZTAPI TWAIN_DibWidth(HANDLE hdib);
// Width of DIB, in pixels (columns)

Function TWAIN_DibHeight;external 'eztw32.dll' name 'TWAIN_DibHeight';
//int EZTAPI TWAIN_DibHeight(HANDLE hdib);
// Height of DIB, in lines (rows)

Function TWAIN_DibNumColors;external 'eztw32.dll' name 'TWAIN_DibNumColors';
// int EZTAPI TWAIN_DibNumColors(HANDLE hdib);
// Number of colors in color table of DIB


Function  TWAIN_CreateDibPalette;external 'eztw32.dll' name 'TWAIN_CreateDibPalette';
// HPALETTE EZTAPI TWAIN_CreateDibPalette(HANDLE hdib);
// Create and return a logical palette to be used for drawing the DIB.
// For 1, 4, and 8-bit DIBs the palette contains the DIB color table.
// For 24-bit DIBs, a default halftone palette is returned.


Procedure TWAIN_DrawDibToDC;external 'eztw32.dll' name 'TWAIN_DrawDibToDC';
(*void EZTAPI TWAIN_DrawDibToDC(
		HDC hDC,		// destination device context
		int dx, int dy,	// destination (x,y)
		int w, int h,	// width and height
		HANDLE hdib,	// DIB handle
		int sx, int sy	// source (x,y) in DIB
		);   *)
// Draws a DIB on a device context.
// You should call CreateDibPalette, select that palette
// into the DC, and do a RealizePalette(hDC) first.

//--------- BMP file utilities

Function TWAIN_WriteNativeToFilename;external 'eztw32.dll' name 'TWAIN_WriteNativeToFilename';

//int EZTAPI TWAIN_WriteNativeToFilename(HANDLE hdib, LPCSTR pszFile);
// Writes a DIB handle to a .BMP file
//
// hdib		= DIB handle, as returned by TWAIN_AcquireNative
// pszFile	= far pointer to NUL-terminated filename
// If pszFile is NULL or points to a null string, prompts the user
// for the filename with a standard file-save dialog.
//
// Return values:
//	 0	success
//	-1	user cancelled File Save dialog
//	-2	file open error (invalid path or name, or access denied)
//	-3	(weird) unable to lock DIB - probably an invalid handle.
//	-4	writing BMP data failed, possibly output device is full


Function  TWAIN_WriteNativeToFile;external 'eztw32.dll' name 'TWAIN_WriteNativeToFile';
// int EZTAPI TWAIN_WriteNativeToFile(HANDLE hdib, HFILE fh);
// Writes a DIB to a file in .BMP format.
//
// hdib		= DIB handle, as returned by TWAIN_AcquireNative
// fh		= file handle, as returned by _open, _lopen or OpenFile
//
// Return value as for TWAIN_WriteNativeToFilename

Function TWAIN_LoadNativeFromFilename;external 'eztw32.dll' name 'TWAIN_LoadNativeFromFilename';
// HANDLE EZTAPI TWAIN_LoadNativeFromFilename(LPCSTR pszFile);
// Load a .BMP file and return a DIB handle (as from AcquireNative.)
// Accepts a filename (including path & extension).
// If pszFile is NULL or points to a null string, the user is prompted.
// Returns a DIB handle if successful, otherwise NULL.


Function TWAIN_LoadNativeFromFile;external 'eztw32.dll' name 'TWAIN_LoadNativeFromFile';
//HANDLE EZTAPI TWAIN_LoadNativeFromFile(HFILE fh);
// Like LoadNativeFromFilename, but takes an already open file handle.

//--------- Application Registration


Procedure TWAIN_RegisterApp;external 'eztw32.dll' name 'TWAIN_RegisterApp';
(*
void EZTAPI TWAIN_RegisterApp(	// record application information
	int		nMajorNum, int nMinorNum,	// major and incremental revision of application. E.g.
                                                        // for version 2.1, nMajorNum == 2 and nMinorNum == 1
	int		nLanguage,		        // language of this version (use TWLG_xxx from TWAIN.H)
	int		nCountry,		        // country of this version (use TWCY_xxx from TWAIN.H)
	LPSTR	lpszVersion,				// version info string e.g. "1.0b3 Beta release"
	LPSTR	lpszMfg,			        // name of manufacturer/developer e.g. "Crazbat Software"
	LPSTR	lpszFamily,				// product family e.g. "BitStomper"
	LPSTR	lpszProduct);	*)			// specific product e.g. "BitStomper Deluxe Pro"
//
// TWAIN_RegisterApp can be called *AS THE FIRST CALL*, to register the
// application. If this function is not called, the application is given a
// 'generic' registration by EZTWAIN.
// Registration only provides this information to the Source Manager and any
// sources you may open - it is used for debugging, and (frankly) by some
// sources to give special treatment to certain applications.

//--------- Lower-level functions for greater control of the TWAIN protocol --------


Procedure TWAIN_SetHideUI;external 'eztw32.dll' name 'TWAIN_SetHideUI';
Function  TWAIN_GetHideUI;external 'eztw32.dll' name 'TWAIN_GetHideUI';
//void EZTAPI TWAIN_SetHideUI(int fHide);
//int EZTAPI TWAIN_GetHideUI(void);
// These functions control the 'hide source user interface' flag.
// This flag is cleared initially, but if you set it non-zero, then when
// a source is enabled it will be asked to hide its user interface.
// Note that this is only a request - some sources will ignore it!
// This affects AcquireNative, AcquireToClipboard, and EnableSource.
// If the user interface is hidden, you will probably want to set at least
// some of the basic acquisition parameters yourself - see
// SetCurrentUnits, SetBitDepth, SetCurrentPixelType and
// SetCurrentResolution below.

// unsigned EZTAPI TWAIN_GetResultCode(void);
Function TWAIN_GetResultCode;external 'eztw32.dll' name 'TWAIN_ GetResultCode';
// Return the result code (TWRC_xxx) from the last triplet sent to TWAIN

// unsigned EZTAPI TWAIN_GetConditionCode(void);
Function TWAIN_GetConditionCode;external 'eztw32.dll' name 'TWAIN_GetConditionCode';
// Return the condition code from the last triplet sent to TWAIN.
// (To be precise, from the last call to TWAIN_DS below)
// If a source is NOT open, return the condition code of the source manager.


// int EZTAPI TWAIN_LoadSourceManager(void);
Function TWAIN_LoadSourceManager; external 'eztw32.dll' name 'TWAIN_LoadSourceManager';
// Finds and loads the Data Source Manager, TWAIN.DLL.
// If Source Manager is already loaded, does nothing and returns TRUE.
// This can fail if TWAIN.DLL is not installed (in the right place), or
// if the library cannot load for some reason (insufficient memory?) or
// if TWAIN.DLL has been corrupted.

//int EZTAPI TWAIN_OpenSourceManager(HWND hwnd);

Function TWAIN_OpenSourceManager;external 'eztw32.dll' name 'TWAIN_OpenSourceManager';
// Opens the Data Source Manager, if not already open.
// If the Source Manager is already open, does nothing and returns TRUE.
// This call will fail if the Source Manager is not loaded.
//int EZTAPI TWAIN_OpenDefaultSource(void);

Function TWAIN_OpenDefaultSource;external 'eztw32.dll' name 'TWAIN_OpenDefaultSource';
// This opens the source selected in the Select Source dialog.
// If a source is already open, does nothing and returns TRUE.
// Fails if the source manager is not loaded and open.

//int EZTAPI TWAIN_EnableSource(HWND hwnd);

Function TWAIN_EnableSource;external 'eztw32.dll' name 'TWAIN_EnableSource';
// Enables the open Data Source. This posts the source's user interface
// and allows image acquisition to begin.  If the source is already enabled,
// this call does nothing and returns TRUE.
//int EZTAPI TWAIN_DisableSource(void);

Function TWAIN_DisableSource;external 'eztw32.dll' name 'TWAIN_DisableSource';
// Disables the open Data Source, if any.
// This closes the source's user interface.
// If there is not an enabled source, does nothing and returns TRUE.

//int EZTAPI TWAIN_CloseSource(void);
Function TWAIN_CloseSource;external 'eztw32.dll' name 'TWAIN_CloseSource';
// Closes the open Data Source, if any.
// If the source is enabled, disables it first.
// If there is not an open source, does nothing and returns TRUE.

//int EZTAPI TWAIN_CloseSourceManager(HWND hwnd);
Function TWAIN_CloseSourceManager;external 'eztw32.dll' name 'TWAIN_CloseSourceManager';
// Closes the Data Source Manager, if it is open.
// If a source is open, disables and closes it as needed.
// If the Source Manager is not open, does nothing and returns TRUE.

//int EZTAPI TWAIN_UnloadSourceManager(void);
Function TWAIN_UnloadSourceManager;external 'eztw32.dll' name 'TWAIN_UnloadSourceManager';
// Unloads the Data Source Manager i.e. TWAIN.DLL - releasing
// any associated memory or resources.
// This call will fail if the Source Manager is open, otherwise
// it always succeeds and returns TRUE.


//int EZTAPI TWAIN_MessageHook(LPMSG lpmsg);
Function TWAIN_MessageHook;external 'eztw32.dll' name 'TWAIN_MessageHook';
// This function detects Windows messages that should be routed
// to an enabled Data Source, and picks them off.  In a full TWAIN
// app, TWAIN_MessageHook is called inside the main GetMessage loop.
// The skeleton code looks like this:
//		MSG msg;
//  	while (GetMessage((LPMSG)&msg, NULL, 0, 0)) {
//			if (!TWAIN_MessageHook ((LPMSG)&msg)) {
//				TranslateMessage ((LPMSG)&msg);
//				DispatchMessage ((LPMSG)&msg);
//			}
//		} // while


// void EZTAPI TWAIN_ModalEventLoop(void);
PROCEDURE  TWAIN_ModalEventLoop;external 'eztw32.dll' name 'TWAIN_ModalEventLoop';
// Process messages until termination, source disable, or image transfer.
//
// Executes exactly the sample code given above for TWAIN_MessageHook, but
// terminates as soon as the source is disabled or a transfer completes.
// This function is called by TWAIN_AcquireNative.


// int EZTAPI TWAIN_AbortAllPendingXfers(void);
Function TWAIN_AbortAllPendingXfers;external 'eztw32.dll' name 'TWAIN_AbortAllPendingXfers';


Function  TWAIN_WriteDibToFile;external 'eztw32.dll' name 'TWAIN_WriteDibToFile';
// int EZTAPI TWAIN_WriteDibToFile(LPBITMAPINFOHEADER lpDIB, HFILE fh);
// Writes a DIB to a file in .BMP format.
// Returns TRUE if successful, FALSE otherwise.
// (Likely causes of failure: device full, or permission denied to write to file or device
// lpDIB	= pointer to DIB, as from GlobalLock of DIB handle
// fh		= file handle, as returned by C _open or Windows _lopen or OpenFile
// For example of use, see TWAIN_WriteNativeToFilename in EZTWAIN.C

//int EZTAPI TWAIN_NegotiateXferCount(int nXfers);
Function  TWAIN_NegotiateXferCount;external 'eztw32.dll' name 'TWAIN_NegotiateXferCount';
// Negotiate with open Source the number of images application will accept.
// This is only allowed in State 4 (TWAIN_SOURCE_OPEN)
// nXfers = -1 means any number


// int EZTAPI TWAIN_NegotiatePixelTypes(unsigned wPixTypes);
Function TWAIN_NegotiatePixelTypes;external 'eztw32.dll' name 'TWAIN_NegotiatePixelTypes';
// Negotiate with the source to restrict pixel types that can be acquired.
// This tries to restrict the source to a *set* of pixel types,
// See TWAIN_AcquireNative above for some mask constants.
// --> This is only allowed in State 4 (TWAIN_SOURCE_OPEN)
// A parameter of 0 (TWAIN_ANYTYPE) causes no negotiation & no restriction.
// You should not assume that the source will honor your restrictions, even
// if this call succeeds!


// int EZTAPI TWAIN_GetCurrentUnits(void);
Function TWAIN_GetCurrentUnits;external 'eztw32.dll' name 'TWAIN_GetCurrentUnits';
// Ask the source what its current unit of measure is.
// If anything goes wrong, this function just returns TWUN_INCHES (0).


//int EZTAPI TWAIN_SetCurrentUnits(int nUnits);
Function TWAIN_SetCurrentUnits;external 'eztw32.dll' name 'TWAIN_SetCurrentUnits';
// Set the current unit of measure for the source.
// Unit of measure codes are in TWAIN.H, but TWUN_INCHES is 0.


//int EZTAPI TWAIN_GetBitDepth(void);
Function TWAIN_GetBitDepth; external 'eztw32.dll' name 'TWAIN_GetBitDepth';
// Get the current bitdepth, which can depend on the current PixelType.
// Bit depth is per color channel e.g. 24-bit RGB has bit depth 8.
// If anything goes wrong, this function returns 0.


// int EZTAPI TWAIN_SetBitDepth(int nBits);
Function TWAIN_SetBitDepth;external 'eztw32.dll' name 'TWAIN_SetBitDepth';
// (Try to) set the current bitdepth (for the current pixel type).


//int EZTAPI TWAIN_GetPixelType(void);
Function TWAIN_GetPixelType; external 'eztw32.dll' name 'TWAIN_GetPixelType';
// Ask the source for the current pixel type.
// If anything goes wrong (it shouldn't), this function returns 0 (TWPT_BW).


//int EZTAPI TWAIN_SetCurrentPixelType(int nPixType);
Function TWAIN_SetCurrentPixelType;external 'eztw32.dll' name 'TWAIN_SetCurrentPixelType';
// (Try to) set the current pixel type for acquisition.
// This is only allowed in State 4 (TWAIN_SOURCE_OPEN)
// The source may select this pixel type, but don't assume it will.


// double EZTAPI TWAIN_GetCurrentResolution(void);
Function TWAIN_GetCurrentResolution;external 'eztw32.dll' name 'TWAIN_GetCurrentResolution';
// Ask the source for the current resolution.
// Resolution is in dots per current unit! (See TWAIN_GetCurrentUnits above)
// If anything goes wrong (it shouldn't) this function returns 0.0


//int EZTAPI TWAIN_SetCurrentResolution(double dRes);
Function TWAIN_SetCurrentResolution ;external 'eztw32.dll' name 'TWAIN_SetCurrentResolution';
// (Try to) set the current resolution for acquisition.
// Resolution is in dots per current unit! (See TWAIN_GetCurrentUnits above)
// This is only allowed in State 4 (TWAIN_SOURCE_OPEN)
// Note: The source may select this resolution, but don't assume it will.


//--------- Low-level capability negotiation functions --------

// Setting a capability is valid only in State 4 (TWAIN_SOURCE_OPEN)
// Getting a capability is valid in State 4 or any higher state.


//int EZTAPI TWAIN_SetCapOneValue(unsigned Cap,
//                                           unsigned ItemType,
//                                           long ItemVal);
Function TWAIN_SetCapOneValue; external 'eztw32.dll' name 'TWAIN_SetCapOneValue';
// Do a DAT_CAPABILITY/MSG_SET, on capability 'Cap' (e.g. ICAP_PIXELTYPE,
// CAP_AUTOFEED, etc.) using a TW_ONEVALUE container with the given item type
// and value.  Obviously, the item value must fit into 32 bits.
// Returns TRUE (1) if successful, FALSE (0) otherwise.


//int EZTAPI TWAIN_GetCapCurrent(unsigned Cap,
//                                          unsigned ItemType,
//                                          void FAR *pVal);
Function TWAIN_GetCapCurrent; external 'eztw32.dll' name 'TWAIN_GetCapCurrent';
// Do a DAT_CAPABILITY/MSG_GETCURRENT on capability 'Cap'.
// Copy the current value out of the returned container into *pVal.
// If the operation fails (the source refuses the request), or if the
// container is not a ONEVALUE or ENUMERATION, or if the item type of the
// returned container is incompatible with the expected TWTY_ type in nType,
// returns FALSE.  If this function returns FALSE, *pVal is not touched.

//--------- Lowest-level functions for TWAIN protocol --------


//int EZTAPI TWAIN_DS(unsigned long DG, unsigned DAT, unsigned MSG, void FAR *pData);
Function TWAIN_DS; external 'eztw32.dll' name 'TWAIN_DS';
// Passes the triplet (DG, DAT, MSG, pData) to the open data source if any.
// Returns 1 (TRUE) if the result code is TWRC_SUCCESS, 0 (FALSE) otherwise.
// The last result code can be retrieved with TWAIN_GetResultCode(), and the corresponding
// condition code can be retrieved with TWAIN_GetConditionCode().
// If no source is open this call will fail, result code TWRC_FAILURE, condition code TWCC_NODS.


//int EZTAPI TWAIN_Mgr(unsigned long DG, unsigned DAT, unsigned MSG, void FAR *pData);
Function  TWAIN_Mgr; external 'eztw32.dll' name 'TWAIN_Mgr';
// Passes a triplet to the Data Source Manager (DSM).
// Returns 1 (TRUE) if the result code is TWRC_SUCCESS, 0 (FALSE) otherwise.
// The last result code can be retrieved with TWAIN_GetResultCode(), and the corresponding
// condition code can be retrieved with TWAIN_GetConditionCode().
// If the Source Manager is not open, this call will fail, and set the result code to TWRC_FAILURE,
// with a condition code of TWCC_SEQERROR (triplet out of sequence).

end.


 